from rouge_score import rouge_scorer
import json
def calculate_rouge(reference, hypothesis):
    scorer = rouge_scorer.RougeScorer(['rouge1', 'rouge2', 'rougeL'], use_stemmer=True)
    scores = scorer.score(reference, hypothesis)
    return scores

if __name__ == '__main__':
    data_path = 'benchmarks/fine_tuning/train_complete_text.json'
    data = json.load(open(data_path, "r"))
    complete_text = data['complete_text']
    last_text = data['last_text']
    labels = data['labels']


    
# 示例参考文本和假设文本
reference = "The quick brown fox jumps over the lazy dog"
hypothesis = "The fast brown fox jumps over the lazy dog"

# 计算 ROUGE 分数
rouge_scores = calculate_rouge(reference, hypothesis)

# 打印结果
for key, value in rouge_scores.items(): 
    print(f"{key}: Precision: {value.precision:.4f}, Recall: {value.recall:.4f}, F1 Score: {value.fmeasure:.4f}")